package gov.va.genisis2.exceptions;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.AbstractMockMvcTests;

/**
 * 
 * @author1 Janet Lopez
 * 
 * The Class Genisis2RestExceptionTest.
 * 
 * Description: In this Genisis2RestExceptionTest Class which extends the abstract
 * class, AbstractMockMvcTests, junit tests are defined.
 */
public class Genisis2RestExceptionTest extends AbstractMockMvcTests {
	
	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(Genisis2RestExceptionTest.class);

	/**
	 * Test genisis 2 rest exception.
	 */
	@Test
	public void TestGenisis2RestException() {
		LOGGER.info("**********Junit Test Genisis2 Rest Exception**********");
		Genisis2RestException genisis2RestException = new Genisis2RestException(null);
		Assert.assertNull(genisis2RestException.getErrorMessage());
		Assert.assertNull(genisis2RestException.getMessage());

		genisis2RestException = new Genisis2RestException("errorMessageTestOne");
		Assert.assertEquals("errorMessageTestOne", genisis2RestException.getErrorMessage());

		LOGGER.info("**********End of Junit Test Genisis2 Rest Exception**********");
	}
}
